/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.soap.server;

import filenet.pe.soap.SOAPUtility;
import filenet.vw.api.VWException;
import filenet.vw.base.logging.Logger;
import filenet.vw.base.logging.VWTimerLog;
import filenet.vw.server.IPECommands;
import filenet.vw.soap.server.IVWCommandManager;
import filenet.vw.soap.server.VWRouterInfo;
import filenet.vw.soap.server.VWSOAPSessionInfo;
import filenet.vw.soap.util.VWSOAPUtils;
import java.lang.reflect.Method;
import java.util.Hashtable;
import org.apache.soap.Constants;
import org.apache.soap.SOAPException;

class VWSOAPCommandHandler {
    private VWSOAPSessionInfo m_peregrineSession = null;
    private VWRouterInfo m_routerInfo = null;
    private IPECommands m_command = null;
    private IVWCommandManager m_commandManager = null;
    protected static Logger exceptionLogger = Logger.getLogger("filenet.pe.rpc.exception");
    private static String m_className = "VWSOAPCommandHandler";
    private String m_prefix = "";
    private static Hashtable IPECommandsMethodsTable;

    public static String _get_FILE_DATE() {
        return "$Date:   01 Nov 2006 15:15:24  $";
    }

    public static String _get_FILE_AUTHOR() {
        return "$Author:   qdang  $";
    }

    public static String _get_FILE_REVISION() {
        return "$Revision:   1.24  $";
    }

    protected VWSOAPCommandHandler(VWRouterInfo routerInfo, IPECommands cmd, VWSOAPSessionInfo peregrineSession, IVWCommandManager commandManager) throws SOAPException {
        this.m_routerInfo = routerInfo;
        this.m_command = cmd;
        this.m_peregrineSession = peregrineSession;
        this.m_prefix = "soapserver[" + routerInfo.getFullURL() + "] ";
        this.m_commandManager = commandManager;
    }

    public byte[] sendCommand(String rpc, byte[] svrCmd) throws SOAPException {
        String m_method = "sendCommand:" + this.m_prefix + " RPC=" + rpc;
        VWTimerLog timer = new VWTimerLog(m_method);
        try {
            Method m = (Method)IPECommandsMethodsTable.get(rpc);
            if (m == null) {
                throw new Exception("Unable to find " + rpc);
            }
            Object[] params = (Object[])SOAPUtility.BytesToObject(rpc, svrCmd);
            if (this.m_command == null) {
                this.m_command = this.m_commandManager.getCommand(this.m_routerInfo.getFullURL(), true);
            }
            Object res = m.invoke((Object)this.m_command, params);
            byte[] byArray = SOAPUtility.ObjectToBytes(rpc, res);
            return byArray;
        }
        catch (Throwable ex) {
            Throwable t = VWException.getRealCause(ex);
            String s = VWException.DescribeThrowableAndItsCauseWithStackFrames(t, 20);
            exceptionLogger.severe(m_className, m_method, s);
            if (t instanceof VWException) {
                s = VWSOAPUtils.base64ObjectSerializer(t);
            }
            SOAPException se = new SOAPException(Constants.FAULT_CODE_SERVER, s, t);
            throw se;
        }
        finally {
            timer.stop();
        }
    }

    public synchronized void cleanup() {
        this.m_peregrineSession = null;
        this.m_routerInfo = null;
        this.m_command = null;
    }

    static {
        Method[] ms = IPECommands.class.getMethods();
        int nMethods = ms == null ? 0 : ms.length;
        IPECommandsMethodsTable = new Hashtable(nMethods);
        for (int i = 0; i < nMethods; ++i) {
            IPECommandsMethodsTable.put(ms[i].getName(), ms[i]);
        }
    }
}

